/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendaryHeroMaker;

import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryHeroMaker.CardRarity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class HeroCard {
    public String name;
    public int nameSize;
    public String heroName;
    public int heroNameSize;
    public CardRarity rarity;
    public Icon cardTeam;
    public Icon cardTeam2;
    public Icon cardPower;
    public Icon cardPower2;
    public String attack;
    public String recruit;
    public String cost;
    public String abilityText;
    public int abilityTextSize;
    public boolean changed;
    public String imagePath;
    public double imageZoom = 1.0;
    public int imageOffsetX = 0;
    public int imageOffsetY = 0;
    public int numberInDeck = -1;
    public ImageIcon imageSummary;

    public String getCardName(String exportDir) {
        if (this.rarity != null && this.rarity.equals((Object)CardRarity.COMMON)) {
            int i = 1;
            String fileName = String.valueOf(this.heroName.replace(" ", "")) + "_" + this.rarity.toString().toLowerCase() + "_" + i;
            do {
                fileName = String.valueOf(this.heroName.replace(" ", "")) + "_" + this.rarity.toString().toLowerCase() + "_" + i;
                ++i;
            } while (new File(String.valueOf(exportDir) + File.separator + fileName + ".jpg").exists() || new File(String.valueOf(exportDir) + File.separator + fileName + ".png").exists());
            return fileName;
        }
        if (this.rarity != null) {
            int i = 1;
            String filename = String.valueOf(this.heroName.replace(" ", "")) + "_" + this.rarity.toString().toLowerCase() + "_" + i;
            do {
                filename = String.valueOf(this.heroName.replace(" ", "")) + "_" + this.rarity.toString().toLowerCase() + "_" + i;
                ++i;
            } while (new File(String.valueOf(exportDir) + File.separator + filename + ".jpg").exists() || new File(String.valueOf(exportDir) + File.separator + filename + ".png").exists());
            return filename;
        }
        int i = 1;
        String filename = String.valueOf(this.heroName.replace(" ", "")) + "_" + this.name + "_" + i;
        do {
            filename = String.valueOf(this.heroName.replace(" ", "")) + "_" + this.name + "_" + i;
            ++i;
        } while (new File(String.valueOf(exportDir) + File.separator + filename + ".jpg").exists() || new File(String.valueOf(exportDir) + File.separator + filename + ".png").exists());
        return filename;
    }

    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    public String generateOutputString(boolean fullExport) {
        String str = "";
        str = String.valueOf(str) + "HEROCARD;\n";
        str = String.valueOf(str) + "HCNAME;" + this.name + "\n";
        if (this.name != null) {
            str = String.valueOf(str) + "HCNAMESIZE;" + this.nameSize + "\n";
        }
        if (this.name != null) {
            str = String.valueOf(str) + "HCHERONAMESIZE;" + this.heroNameSize + "\n";
        }
        if (this.rarity != null) {
            str = String.valueOf(str) + "HCRARITY;" + this.rarity.toString() + "\n";
        }
        if (this.cardTeam != null) {
            str = String.valueOf(str) + "HCTEAM;" + this.cardTeam.toString() + "\n";
        }
        if (this.cardTeam2 != null) {
            str = String.valueOf(str) + "HCTEAM2;" + this.cardTeam2.toString() + "\n";
        }
        if (this.cardPower != null) {
            str = String.valueOf(str) + "HCPOWER;" + this.cardPower.toString() + "\n";
        }
        if (this.cardPower2 != null) {
            str = String.valueOf(str) + "HCPOWER2;" + this.cardPower2.toString() + "\n";
        }
        if (this.attack != null) {
            str = String.valueOf(str) + "HCATTACK;" + this.attack + "\n";
        }
        if (this.recruit != null) {
            str = String.valueOf(str) + "HCRECRUIT;" + this.recruit + "\n";
        }
        if (this.cost != null) {
            str = String.valueOf(str) + "HCCOST;" + this.cost + "\n";
        }
        if (this.abilityText != null) {
            str = String.valueOf(str) + "HCTEXT;" + this.abilityText + "\n";
        }
        if (this.abilityText != null) {
            str = String.valueOf(str) + "HCTEXTSIZE;" + this.abilityTextSize + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "HCIMAGEPATH;" + this.imagePath + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "HCIMAGEZOOM;" + this.imageZoom + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "HCIMAGEOFFSETX;" + this.imageOffsetX + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "HCIMAGEOFFSETY;" + this.imageOffsetY + "\n";
        }
        str = String.valueOf(str) + "HCNUMBERINDECK;" + this.numberInDeck + "\n";
        str = String.valueOf(str) + "HCGENERATE;\n";
        return str;
    }

    public String getTextExportString() {
        String str = "";
        str = String.valueOf(str) + this.rarity.toString();
        if (this.numberInDeck > 0) {
            str = String.valueOf(str) + " (" + this.numberInDeck + " in deck)";
        }
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + this.name;
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + this.cardTeam.toString();
        if (this.cardTeam2 != null) {
            str = String.valueOf(str) + " + " + this.cardTeam2.toString();
        }
        str = String.valueOf(str) + ", " + this.cardPower.toString();
        if (this.cardPower2 != null) {
            str = String.valueOf(str) + " + " + this.cardPower2.toString();
        }
        str = String.valueOf(str) + "\n";
        if (this.attack != null || this.recruit != null || this.cost != null) {
            if (this.attack != null) {
                str = String.valueOf(str) + "Attack " + this.attack;
                if (this.recruit != null || this.cost != null) {
                    str = String.valueOf(str) + ", ";
                }
            }
            if (this.recruit != null) {
                str = String.valueOf(str) + "Recruit " + this.recruit;
                if (this.cost != null) {
                    str = String.valueOf(str) + ", ";
                }
            }
            if (this.cost != null) {
                str = String.valueOf(str) + "Cost " + this.cost;
            }
            str = String.valueOf(str) + "\n";
        }
        if (this.abilityText != null) {
            str = String.valueOf(str) + this.abilityText.replace("<k>", "").replace("<r>", "").replace(" <g> ", "\n");
        }
        return str;
    }

    public List<String> getTriggers() {
        ArrayList<String> triggers = new ArrayList<String>();
        if (this.abilityText != null) {
            String[] split;
            String[] stringArray = split = this.abilityText.split(" <g> ");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                String trigger = "";
                String[] words = str.split(" ");
                if (words.length > 0) {
                    System.out.println(words[0]);
                    if (words[0].startsWith("<") && Icon.valueOf(words[0].replace("<", "").replace(">", "")) != null) {
                        trigger = String.valueOf(trigger) + words[0];
                        if (words.length > 1 && words[1].startsWith("<") && Icon.valueOf(words[1].replace("<", "").replace(">", "")) != null) {
                            trigger = String.valueOf(trigger) + words[1];
                        }
                        triggers.add(trigger);
                    }
                }
                ++n2;
            }
        }
        return triggers;
    }

    public Integer getBaseAttack() {
        if (this.attack == null) {
            return 0;
        }
        try {
            return Integer.parseInt(this.attack.replace(" ", "").replace("+", ""));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Integer getBaseRecruit() {
        if (this.recruit == null) {
            return 0;
        }
        try {
            return Integer.parseInt(this.recruit.replace(" ", "").replace("+", ""));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Integer getBaseCost() {
        if (this.cost == null) {
            return 0;
        }
        try {
            return Integer.parseInt(this.cost.replace(" ", "").replace("+", ""));
        }
        catch (Exception e) {
            return 0;
        }
    }
}

